﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace FileListBoxDemo
{
    public partial class FileListBox : UserControl
    {
        #region Pola prywatne
        //wewnętrzne
        private string[] listaKatalogow = null;
        private string[] listaPlikow = null;
        private string[] listaDyskow = null;
        private bool pokazujDwieKropki = true;
        //konfigurowanie komponentu
        private string sciezkaKatalogu = null;
        private bool uwzglednijKatalogi = true;
        private bool uwzglednijPliki = true;
        private bool uwzglednijDyski = true;
        private bool uwzglednijKatalogNadrzedny = true;
        private string filtr = null;
        #endregion

        #region Metody prywatne
        private void PobierzZawartoscKatalogu()
        {
            if (sciezkaKatalogu == null)
                sciezkaKatalogu = Directory.GetCurrentDirectory();

            pokazujDwieKropki = (sciezkaKatalogu != Path.GetPathRoot(sciezkaKatalogu)
                               && uwzglednijKatalogNadrzedny);

            if (!Directory.Exists(sciezkaKatalogu))
                throw new DirectoryNotFoundException("Katalog " + sciezkaKatalogu + " nie istnieje!");

            listBox1.Items.Clear();

            if (uwzglednijKatalogi)
            {
                if (pokazujDwieKropki) listBox1.Items.Add("[..]");
                listaKatalogow = Directory.GetDirectories(sciezkaKatalogu);
                Array.Sort(listaKatalogow);
                //listBox1.Items.AddRange(listaKatalogow);
                foreach (string katalog in listaKatalogow)
                    listBox1.Items.Add("[" + Path.GetFileName(katalog) + "]");
            }
            if (uwzglednijPliki)
            {
                //listaPlikow = Directory.GetFiles(sciezkaKatalogu);
                if (filtr != null)
                    listaPlikow = Directory.GetFiles(sciezkaKatalogu, filtr);
                else
                    listaPlikow = Directory.GetFiles(sciezkaKatalogu);
                Array.Sort(listaPlikow);
                //listBox1.Items.AddRange(listaPlikow);
                foreach (string plik in listaPlikow)
                    listBox1.Items.Add(Path.GetFileName(plik));
            }
            if (uwzglednijDyski)
            {
                listaDyskow = Directory.GetLogicalDrives();
                //listBox1.Items.AddRange(listaDyskow);
                foreach (string dysk in listaDyskow)
                    listBox1.Items.Add("<" + dysk.Substring(0, 2) + ">");

            }
        }
        #endregion

        public FileListBox()
        {
            InitializeComponent();

            sciezkaKatalogu = ".";
            filtr = "*.*";

            //sciezkaKatalogu = "C:\\";
            //filtr = "*.sys";

            //sciezkaKatalogu = "C:\\Documents and Settings\\Jacek Matulewski\\Moje dokumenty\\Moje obrazy";
            //sciezkaKatalogu = "C:\\Documents and Settings\\Dom\\Moje dokumenty\\Moje obrazy";
            //filtr = "*.jpg";

            //sciezkaKatalogu = System.Environment.GetFolderPath(System.Environment.SpecialFolder.CommonPictures);
            //filtr = "*.jpg";            
            
            PobierzZawartoscKatalogu();
        }
    }
}
